<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.3
|| # ---------------------------------------------------------------- # ||
|| # Copyright 20002004 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| #                      Nullified by WDYL-WTN Team                  # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'printthread');
define('NO_REGISTER_GLOBALS', 1);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('showthread');

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
	'printthread',
	'printthreadbit',
	'bbcode_code',
	'bbcode_html',
	'bbcode_php',
	'bbcode_quote',
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once('./includes/functions_bbcodeparse.php');
require_once('./includes/functions_bigthree.php');
//         ##### [hide] [/hide] start #####
require_once('./includes/functions_hide.php');
//         ##### [hide] [/hide] end #####
// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

globalize($_REQUEST, array('perpage' => INT, 'pagenumber' => INT));

// oldest first or newest first
if ($bbuserinfo['postsorder'] == 0)
{
	$postorder = '';
}
else
{
	$postorder = 'DESC';
}

$threadid = verify_id('thread', $_REQUEST['threadid']);
if ($vboptions['wordwrap'])
{
	$threadinfo['title'] = fetch_word_wrapped_string($threadinfo['title']);
}

if (!$threadinfo['visible'] OR $threadinfo['isdeleted'] OR (in_coventry($threadinfo['postuserid']) AND !can_moderate($threadinfo['forumid'])))
{
	$idname = $vbphrase['thread'];
	eval(print_standard_error('error_invalidid'));
}

$forumperms = fetch_permissions($threadinfo['forumid']);
if (!($forumperms & CANVIEW))
{
	print_no_permission();
}
if (!($forumperms & CANVIEWOTHERS) AND ($threadinfo['postuserid'] != $bbuserinfo['userid'] OR $bbuserinfo['userid'] == 0))
{
	print_no_permission();
}

if ($threadinfo['open'] == 10)
{
	exec_header_redirect("printthread.php?$session[sessionurl_js]t=$threadinfo[pollid]");
}

// check if there is a forum password and if so, ensure the user has it set
verify_forum_password($foruminfo['forumid'], $foruminfo['password']);

// split thread over pages if necessary
$countposts = $DB_site->query_first("
	SELECT COUNT(*) AS total
	FROM " . TABLE_PREFIX . "post AS post
	LEFT JOIN " . TABLE_PREFIX . "deletionlog AS deletionlog ON(deletionlog.primaryid = post.postid AND type = 'post')
	WHERE threadid=$threadid AND visible=1 AND deletionlog.primaryid IS NULL
");
$totalposts = $countposts['total'];


$checkmax = explode(',', $vboptions['usermaxposts'] . ',' . $vboptions['maxposts']);
$maxperpage = max($checkmax);

if (empty($perpage) OR $perpage < 1)
{
	$perpage = iif($bbuserinfo['maxposts'] > 0, $bbuserinfo['maxposts'], $vboptions['maxposts']);
}

if ($perpage > $maxperpage)
{
	$perpage = $vboptions['maxposts'];
}

if ($pagenumber < 1)
{
	$pagenumber = 1;
}
$startat = ($pagenumber - 1) * $perpage;

$pagenav = construct_page_nav($totalposts, "printthread.php?$session[sessionurl]t=$threadid", "&amp;pp=$perpage");
// end page splitter

$posts = $DB_site->query("
	SELECT post.*,post.username AS postusername,user.username
	FROM " . TABLE_PREFIX . "post AS post
	LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = post.userid)
	LEFT JOIN " . TABLE_PREFIX . "deletionlog AS deletionlog ON(deletionlog.primaryid = post.postid AND type = 'post')
	WHERE post.threadid=$threadid AND post.visible=1 AND deletionlog.primaryid IS NULL
	ORDER BY dateline $postorder
	LIMIT $startat, $perpage
");

$postbits = '';
while ($post = $DB_site->fetch_array($posts))
{
	// hide users in Coventry from non-staff members
	if ($tachyuser = in_coventry($post['userid']) AND !can_moderate($threadinfo['forumid']))
	{
		continue;
	}

	$post['postdate'] = vbdate($vboptions['dateformat'], $post['dateline']);
	$post['posttime'] = vbdate($vboptions['timeformat'], $post['dateline']);

	if ($vboptions['wordwrap'])
	{
		$post['title'] = fetch_word_wrapped_string($post['title']);
	}

	if (!$post['userid'])
	{
		$post['username'] = $post['postusername'];
	}

	$post['message'] = parse_bbcode($post['pagetext'], $foruminfo['forumid'], 0);
// ##### [hide] [/hide] start #####
	$hide_shown = 0;
		if (substr($post['message'],0,6)=="[hide]"){$post['message'] = str_replace("[hide]"," [hide]",$post['message']); }
		if ($session[userid] != 0){

			$hideisadmin = $DB_site->query("SELECT " . TABLE_PREFIX . "user.usergroupid FROM " . TABLE_PREFIX . "usergroup," . TABLE_PREFIX . "user WHERE " . TABLE_PREFIX . "usergroup.usergroupid = " . TABLE_PREFIX . "user.usergroupid AND " . TABLE_PREFIX . "user.userid = '$session[userid]'");
			$hideisadmin  = $DB_site->fetch_array($hideisadmin);
			$thez_posts=$DB_site->query("SELECT " . TABLE_PREFIX . "post.userid FROM " . TABLE_PREFIX . "post WHERE " . TABLE_PREFIX . "post.threadid='$threadid'");
			while ($the_posts = $DB_site->fetch_array($thez_posts)) {
				if(($the_posts[userid] == $session[userid]) || ($hideisadmin[usergroupid] == 6)) {
					$post['message'] = str_replace("[hide]","[Hidden Text]: ",$post['message']);
					$post['message'] = str_replace("[/hide]","",$post['message']);
					$hide_shown = 1;
				}
			}
		}

	if ($hide_shown == 0) {
		for ($i = lock_count($post['message'],"[hide]"); $i > 0; $i--) {
			$lock_part1 = strpos($post['message'], "[hide]");
			$lock_part2 = (strpos($post['message'],"[/hide]")-strpos($post['message'],"[hide]"))+7;
			$lock_mess = substr ($post['message'], $lock_part1, $lock_part2);
			$post['message'] = str_replace( $lock_mess, "[Hidden Text]: You must reply to see the hidden text!
", $post['message']);
		}
	}


// ##### [hide] [/hide] End #####
	eval('$postbits .= "' . fetch_template('printthreadbit') . '";');

}

eval('print_output("' . fetch_template('printthread') . '");');

/*======================================================================*\
|| ####################################################################
|| # Supplied/Nullified/Tested/Packaged by WDYL-WTN Team 
|| # CVS: $RCSfile: printthread.php,v $ - $Revision: 1.55 $
|| ####################################################################
\*======================================================================*/
?>
